/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.comm.PortManager;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.ConfigTelNumberModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoAddressBook;
import DE.siemens.ad.pdraw.app.ModemManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ConfigTelNumberPanel
extends WizardInputPanel {
    private ConfigTelNumberModel model;
    private JPanel addressPanel;
    private BorderJPanel connectModemPanel;
    private JTextArea connectInfo;
    private JCheckBox doneCheckBox;
    private JTableForAddressBook fAddressBookTable;
    private JPanel interfacePanel;
    private JLabel interfaceLabel;
    private JComboBox interfaceCombobox;
    private transient boolean fAddressBookLoaded = false;

    public Icon getIcon() {
        return Global.getIcon("ConfigTelNumber.gif");
    }

    public void setLabels() {
        this.title = Language.getString("wizard.modem.configTelNumberPanel.title", "Config telephone number");
    }

    public ConfigTelNumberPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (ConfigTelNumberModel)panelModel;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)new JLabel(this.getIcon()), constraints);
        constraints.insets = new Insets(2, 4, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 100.0;
        this.add((Component)this.getTelephoneListPanel(), constraints);
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 4, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.add((Component)this.getInterfacePanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridheight = 2;
        this.add((Component)this.getConnectModemPanel(), constraints);
    }

    public JPanel getInterfacePanel() {
        if (this.interfacePanel == null) {
            this.interfacePanel = new JPanel(new FlowLayout(0));
            this.interfaceLabel = new JLabel(Language.getString("wizard.modem.configRemoteModemPanel.selectInterface", "Select port"));
            this.interfaceCombobox = new JComboBox(PortManager.getAvailableComPorts());
            this.interfaceCombobox.setSelectedItem(PortManager.getActualComPort());
            this.interfacePanel.add(this.interfaceLabel);
            this.interfacePanel.add(this.interfaceCombobox);
        }
        return this.interfacePanel;
    }

    private JPanel getTelephoneListPanel() {
        if (this.addressPanel == null) {
            this.addressPanel = new JPanel();
            this.addressPanel.setLayout(new GridBagLayout());
            TitledBorder fTitledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
            fTitledBorder.setTitle(Language.getString("wizard.modem.configTelNumberPanel.telephoneList", "Telephone number list"));
            this.addressPanel.setBorder(fTitledBorder);
            this.fAddressBookTable = new JTableForAddressBook();
            JScrollPane scrollpane = new JScrollPane(this.fAddressBookTable);
            scrollpane.setPreferredSize(new Dimension(400, 160));
            scrollpane.setMinimumSize(new Dimension(295, 115));
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            JButton fRemoveButton = new JButton(Language.getString("dialog.options.connectionTab.removeButtonText", "Remove"));
            fRemoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigTelNumberPanel.this.fAddressBookTable.removeSelectedRow();
                    ModemManager.getAddressBook().saveAddressBook();
                }
            });
            JButton fAddNewButton = new JButton(Language.getString("dialog.options.connectionTab.addNewButtonText", "Add New"));
            fAddNewButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigTelNumberPanel.this.fAddressBookTable.addNewRow();
                    ModemManager.getAddressBook().saveAddressBook();
                }
            });
            GridBagConstraints buttonConstraints = new GridBagConstraints();
            buttonConstraints.fill = 2;
            buttonConstraints.anchor = 17;
            buttonConstraints.insets = new Insets(10, 0, 0, 0);
            buttonConstraints.gridx = 0;
            buttonConstraints.gridy = 0;
            buttonPanel.add((Component)fRemoveButton, buttonConstraints);
            buttonConstraints.gridx = 0;
            buttonConstraints.gridy = 1;
            buttonPanel.add((Component)fAddNewButton, buttonConstraints);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.addressPanel.add((Component)scrollpane, constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            this.addressPanel.add((Component)buttonPanel, constraints);
        }
        return this.addressPanel;
    }

    private BorderJPanel getConnectModemPanel() {
        if (this.connectModemPanel == null) {
            this.connectInfo = new JTextArea(Language.getString("wizard.modem.configTelNumberPanel.connectModem", "Connect remote modem to LOGO! and local modem to PC"));
            this.connectInfo.setBackground(this.getBackground());
            this.connectInfo.setFont(this.interfaceLabel.getFont());
            this.connectInfo.setLineWrap(true);
            this.connectInfo.setWrapStyleWord(true);
            this.connectInfo.setEditable(false);
            this.doneCheckBox = new JCheckBox(Language.getString("log.msg.done", "Done"));
            this.doneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigTelNumberPanel.this.model.setFinish(ConfigTelNumberPanel.this.doneCheckBox.isSelected());
                }
            });
            this.connectModemPanel = new BorderJPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridheight = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.connectModemPanel.add((Component)this.connectInfo, constraints);
            constraints.anchor = 16;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridheight = 1;
            this.connectModemPanel.add((Component)this.doneCheckBox, constraints);
        }
        return this.connectModemPanel;
    }

    public void loadFieldContents() {
        if (this.fAddressBookLoaded) {
            return;
        }
        this.fAddressBookTable.loadFieldContents();
        this.fAddressBookLoaded = true;
    }

    public void storeFieldContents() {
        this.fAddressBookTable.storeFieldContents();
        PortManager.setPortSelection(this.interfaceCombobox.getSelectedItem().toString());
    }

    public String getHelpIdString() {
        return "extras.configTelNumber";
    }

    private static class JTableForAddressBook
    extends JTable {
        private static final long serialVersionUID = 8118815641788462776L;
        protected String[][] fAddressData;
        protected TableModel fDataModel;

        public JTableForAddressBook() {
            this.init();
        }

        protected void init() {
            this.setAutoResizeMode(0);
        }

        public void removeSelectedRow() {
            ModemManager.getAddressBook().removeRow(ModemManager.getAddressBook().getSelectedIndex());
            this.refresh();
        }

        public void addNewRow() {
            ModemManager.getAddressBook().addNewRow(new String[]{"new"});
            this.refresh();
        }

        private void refresh() {
            this.fAddressData = null;
            this.setTableColumnWidth();
            this.updateUI();
        }

        public void loadFieldContents() {
            LogoAddressBook.close();
            if (this.fDataModel == null) {
                this.fDataModel = new AbstractTableModel(){
                    private static final long serialVersionUID = 8642729477408054010L;
                    String[] columnNames = ModemManager.getColumnNames();

                    public String getColumnName(int col) {
                        return this.columnNames[col].toString();
                    }

                    public int getColumnCount() {
                        return this.columnNames.length;
                    }

                    public int getRowCount() {
                        if (JTableForAddressBook.this.getData() != null) {
                            return JTableForAddressBook.this.getData().length;
                        }
                        return 0;
                    }

                    public Object getValueAt(int row, int col) {
                        if (JTableForAddressBook.this.getData() != null && row >= 0 && row < JTableForAddressBook.this.getData().length) {
                            return JTableForAddressBook.this.getData()[row][col];
                        }
                        return null;
                    }

                    public boolean isCellEditable(int row, int col) {
                        return true;
                    }

                    public void setValueAt(Object value, int row, int col) {
                        if (JTableForAddressBook.this.getData() == null) {
                            return;
                        }
                        if (row >= 0 && row < JTableForAddressBook.this.getData().length) {
                            ((JTableForAddressBook)JTableForAddressBook.this).getData()[row][col] = value;
                            this.fireTableCellUpdated(row, col);
                        } else {
                            System.out.println("setValueAt row " + row + ", error catched");
                        }
                    }
                };
            }
            this.setModel(this.fDataModel);
            this.setTableColumnWidth();
            this.initColumnComboBoxes();
            this.initRowSelection();
            this.initEditTreating();
        }

        public void storeFieldContents() {
            ModemManager.getAddressBook().saveAddressBook();
            LogoAddressBook.close();
        }

        private Object[][] getData() {
            if (this.fAddressData == null) {
                this.fAddressData = ModemManager.getAddressBook().getData();
            }
            return this.fAddressData;
        }

        private void setTableColumnWidth() {
            TableColumn column = null;
            Component comp = null;
            int headerWidth = 0;
            int cellWidth = 0;
            int cellWidthRow = 0;
            TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                column = this.getColumnModel().getColumn(i);
                comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
                headerWidth = comp.getPreferredSize().width;
                cellWidth = 0;
                for (int j = 0; j < this.getRowCount(); ++j) {
                    comp = this.getDefaultRenderer(this.getModel().getColumnClass(i)).getTableCellRendererComponent(this, this.getData()[j][i], false, false, 0, i);
                    cellWidthRow = comp.getPreferredSize().width + 10;
                    cellWidth = Math.max(cellWidth, cellWidthRow);
                }
                column.setPreferredWidth(Math.max(headerWidth, cellWidth + 10));
            }
        }

        private void initColumnComboBoxes() {
        }

        private void initRowSelection() {
            this.setSelectionMode(0);
            int fSelectedRowIndex = ModemManager.getAddressBook().getSelectedIndex();
            if (fSelectedRowIndex >= 0 && fSelectedRowIndex < this.getRowCount()) {
                this.setRowSelectionInterval(fSelectedRowIndex, fSelectedRowIndex);
            }
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        System.out.println("None selection");
                        ModemManager.getAddressBook().setSelectedIndex(-1);
                    } else {
                        ModemManager.getAddressBook().setSelectedIndex(lsm.getMinSelectionIndex());
                    }
                    ModemManager.getAddressBook().saveAddressBook();
                }
            });
        }

        private void initEditTreating() {
            this.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    try {
                        int row = e.getFirstRow();
                        int column = e.getColumn();
                        if (ModemManager.getAddressBook().updateCell(row, column)) {
                            JTableForAddressBook.this.setTableColumnWidth();
                            ModemManager.getAddressBook().saveAddressBook();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

